<?php
/**
 * Prohibit direct script loading.
 *
 * @package Convert_Plus.
 */

// Add new input type "group_filters".
if ( function_exists( 'smile_add_input_type' ) ) {
	smile_add_input_type( 'group_filters', 'group_filters_settings_field' );
}

/**
 * Function Name:group_filters_settings_field Function to handle new input type "group_filters".
 *
 * @param  string $name     settings provided when using the input type "group_filters".
 * @param  string $settings holds the default / updated value.
 * @param  string $value    html output generated by the function.
 * @return string           html output generated by the function.
 */
function group_filters_settings_field( $name, $settings, $value ) {
	$input_name = $name;
	$type       = isset( $settings['type'] ) ? $settings['type'] : '';
	$class      = isset( $settings['class'] ) ? $settings['class'] : '';

	ob_start();
	?>
	<select name="<?php echo esc_attr( $input_name ); ?>" id="smile_<?php echo esc_attr( $input_name ); ?>" class="select2-group_filters-dropdown form-control smile-input <?php echo esc_attr( 'smile-' . $type . ' ' . $input_name . ' ' . $type . ' ' . $class ); ?>" multiple="multiple" style="width:260px;">

		<?php

		$selected_values = explode( ',', $value );

		foreach ( $selected_values as $key => $sel_value ) {

			// posts.
			if ( false !== strpos( $sel_value, 'post-' ) ) {
				$post_id    = (int) str_replace( 'post-', '', $sel_value );
				$post_title = get_the_title( $post_id );
				echo '<option value="post-' . esc_attr( $post_id ) . '" selected="selected" >' . esc_attr( $post_title ) . '</option>';
			}

			// taxonomy options.
			if ( false !== strpos( $sel_value, 'tax-' ) ) {
				$tax_id        = (int) str_replace( 'tax-', '', $sel_value );
				$term          = get_term( $tax_id );
				$term_taxonomy = ucfirst( str_replace( '_', ' ', $term->taxonomy ) );
				echo '<option value="tax-' . esc_attr( $tax_id ) . '" selected="selected" >' . esc_attr( $term->name ) . ' - ' . esc_attr( $term_taxonomy ) . '</option>';
			}

			// Special Pages.
			$spacial_pages = array(
				'blog'       => 'Blog / Posts Page',
				'front_page' => 'Front Page',
				'archive'    => 'Archive Page',
				'author'     => 'Author Page',
				'search'     => 'Search Page',
				'404'        => '404 Page',
			);

			foreach ( $spacial_pages as $page => $title ) {
				$selected = ( 'special-' . $page == $sel_value ) ? true : false;
				if ( $selected ) {
					echo "<option selected='selected' value='special-" . esc_attr( $page ) . "' >" . esc_attr( $title ) . '</option>';
				}
			}
		}

		?>
	</select>
	<script type="text/javascript">
		jQuery(document).ready(function($) {

			jQuery('select.select2-group_filters-dropdown').cpselect2({
				placeholder: "Search pages / post / categories",

				ajax: {
					url: ajaxurl,
					dataType: 'json',
					method: 'post',
					delay: 250,
					data: function (params) {
						return {
						q: params.term, // search term.
						page: params.page,
						action: 'cp_get_posts_by_query', 
						security_nonce: '<?php echo esc_attr( wp_create_nonce( 'cp_get_posts_by_query_nonce' ) ); ?>'
					};
				},
				processResults: function (data) {

					console.log(data);

					// parse the results into the format expected by Select2..
					// since we are using custom formatting functions we do not need to.
					// alter the remote JSON data.

					return {
						results: data
					};
				},
				cache: true
			},
			minimumInputLength: 2,

		});
		});
	</script>
	<?php
	return ob_get_clean();
}
