<?php
/**
 * Prohibit direct script loading.
 *
 * @package Convert_Plus.
 */

// Add new input type "mailer".
if ( function_exists( 'smile_add_input_type' ) ) {
	smile_add_input_type( 'mailer', 'mailer_settings_field' );
}

/**
 * Function Name:mailer_settings_field Function to handle new input type "switch".
 *
 * @param  string $name     settings provided when using the input type "switch".
 * @param  string $settings holds the default / updated value.
 * @param  string $value    html output generated by the function.
 * @return string           html output generated by the function.
 */
function mailer_settings_field( $name, $settings, $value ) {
	$input_name = $name;
	$type       = isset( $settings['type'] ) ? $settings['type'] : '';
	$class      = isset( $settings['class'] ) ? $settings['class'] : '';
	$options    = get_option( 'smile_lists' );

	$lists = array();
	if ( ! empty( $options ) ) {

		foreach ( $options as $key => $list ) {
			$provider = $list['list-provider'];
			// to unset deactivated / inactive mailer addons.
			if ( isset( Smile_Framework::$addon_list[ strtolower( $provider ) ] ) || 'Convert Plug' === $provider ) {
				$lists[ $list['list-name'] ] = $key;
			}
		}

		$output = '<p><select name="' . $input_name . '" id="smile_' . $input_name . '" class="form-control smile-input smile-select ' . $input_name . ' ' . $type . '">';
		foreach ( $lists as $text_val => $val ) {
			if ( is_numeric( $text_val ) && ( is_string( $val ) || is_numeric( $val ) ) ) {
				$text_val = $val;
			}
			$selected = '';
			if ( '' !== $value && (string) $val === (string) $value ) {
				$selected = ' selected="selected"';
			}
			$output .= '<option class="smile_' . $val . '" value="' . $val . '"' . $selected . '>' . htmlspecialchars( $text_val, ENT_QUOTES, 'utf-8' ) . '</option>';
		}
		if ( 'custom-form' === $value ) {
			$output .= '<option value="custom-form" selected="selected">Custom Form</option>';
		} else {
			$output .= '<option value="custom-form" >Custom Form</option>';
		}

		$output .= '</select></p>';
	} else {
		$url     = add_query_arg(
			array(
				'page' => 'contact-manager',
			),
			admin_url( 'admin.php' )
		);
		$output  = '<p><select name="' . $input_name . '" id="smile_' . $input_name . '" class="form-control smile-input smile-select ' . $input_name . ' ' . $type . '">';
		$output .= '<option value="custom-form" selected="selected">Custom Form</option>';
		$output .= '</select></p>';
		$output .= '<p>' . __( "It seems that you don't have any campaigns yet!", 'smile' ) . ' <a href="' . esc_url( $url ) . '" target=\"_blank\">' . __( 'Click here', 'smile' ) . '</a> to create a new campaign.</p>';
	}
	return $output;
}
